<!DOCTYPE html>
<html lang="nl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Ultimategameplay - Educatief Platform voor Sociale Casino Spelontwikkeling</title>
<meta name="description" content="Ontdek verantwoorde game-ontwikkeling met Ultimategameplay. Leer mobiele sociale casino games creëren zonder echte geldrisico's. Professionele training voor entertainment-industrie in Nederland.">
<link rel="sitemap" type="application/xml" href="./sitemap.xml">
<link rel="icon" type="image/svg" href="./favicon.svg">
<link rel="icon" type="image/png" sizes="32x32" href="./fav-32x32.png">
<link rel="icon" type="image/png" sizes="48x48" href="./fav-48x48.png">
<link rel="icon" type="image/png" sizes="256x256" href="./fav-256x256.png">
<link rel="apple-touch-icon" sizes="180x180" href="./apple-180x180.png">
<link rel="apple-touch-icon" sizes="16x16" href="./apple-16x16.png">
<link rel="apple-touch-icon" sizes="48x48" href="./apple-48x48.png">
<link rel="apple-touch-icon" sizes="96x96" href="./apple-96x96.png">
<link rel="apple-touch-icon" sizes="128x128" href="./apple-128x128.png">
<link rel="apple-touch-icon" sizes="256x256" href="./apple-256x256.png">
<link rel="manifest" href="./manifest.webmanifest">
<link href="./breakpoints.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
<header>
<div class="qx9_container">
<div class="kp7-header_topRow">
<div class="wr3_companyName">Ultimategameplay</div>
<div class="tm4-businessHours">Ma-Vr: 09:00 - 18:00</div>
</div>
</div>
<div class="zx8_header-secondRow">
<div class="qx9_container">
<div class="nb2_promoBar">Ontdek de kunst van <span>verantwoorde game-ontwikkeling</span> voor entertainment</div>
</div>
</div>
<div class="yl5-header_navRow">
<div class="qx9_container">
<div class="vf6_logoWrapper"><img src="./assets/logo.png" alt="Ultimategameplay Logo" class="hj9-logo_image"></div>
<nav class="qw1_mainNav" role="navigation" aria-label="Hoofdnavigatie"><a href="./" class="df3-navLink">Startpagina</a>
<div class="rt8_submenu-wrapper"><a href="./" class="df3-navLink">Startpagina</a>
<div class="xc5_submenuDrop"><a href="./help.php" class="pl2_submenuLink">Support</a></div>
</div>
<a href="./reach-us.php" class="df3-navLink">Neem Contact Op</a> <a href="./games.php" class="df3-navLink">Games</a> <a href="./who-we-are.php" class="df3-navLink">Over Ons</a> <a href="./education.php" class="df3-navLink">Lesprogramma</a></nav>
</div>
</div>
</header>
<main>
<section class="leerplan-hero-wrapper">
<div class="leerplan-hero-content">
<h1>Ontwikkel je toekomst in social casino gaming</h1>
<p class="leerplan-intro-text">Bij Ultimategameplay leer je niet alleen code schrijven. Je leert denken als een gamemaker. Ons programma is opgebouwd uit echte projecten, directe feedback van professionals uit de industrie, en hands-on ervaring met dezelfde tools die grote studios gebruiken.</p>
<p class="leerplan-intro-text">We beginnen bij de basis en bouwen gestaag verder. Tegen het einde van het programma heb je een portfolio vol met speelbare games die je kunt laten zien aan werkgevers.</p>
<div class="leerplan-highlight-box">
<p><strong>Belangrijk om te weten:</strong> Dit is een intensief programma dat toewijding vraagt. Je hebt geen programmeerervaring nodig om te starten, maar wel de wil om nieuwe vaardigheden te leren en toe te passen. Het volgende cohort start in maart 2026.</p>
</div>
</div>
</section>
<section class="curriculum-overzicht-section">
<div class="curriculum-container">
<div class="curriculum-header-block">
<h2>Wat je leert in 8 maanden</h2>
<p class="curriculum-description">Ons curriculum is verdeeld over zes modules die je van beginner naar game developer brengen. Elke module duurt ongeveer 6 weken en eindigt met een concreet project dat je aan je portfolio toevoegt.</p>
</div>
<div class="modules-grid-layout">
<div class="module-card-item"><span class="module-number-badge">Module 1</span>
<h3>Fundamenten van game development</h3>
<div class="module-duration-info">6 weken · 12-15 uur per week</div>
<p class="module-description-text">We beginnen met de basis: JavaScript, HTML5 Canvas, en de core concepten van game loops. Je bouwt je eerste werkende game aan het einde van deze module.</p>
<ul class="module-topics-list">
<li>JavaScript fundamentals voor games</li>
<li>Canvas rendering en animatie</li>
<li>Input handling en event systems</li>
<li>Game state management</li>
<li>Project: Een werkende slot machine interface</li>
</ul>
</div>
<div class="module-card-item"><span class="module-number-badge">Module 2</span>
<h3>Mobile-first development</h3>
<div class="module-duration-info">6 weken · 12-15 uur per week</div>
<p class="module-description-text">Social casino games draaien vooral op mobiel. Je leert responsive design, touch controls, en performance optimization voor kleinere schermen.</p>
<ul class="module-topics-list">
<li>Responsive canvas design</li>
<li>Touch en swipe interacties</li>
<li>Mobile performance patterns</li>
<li>Asset optimization voor mobiel</li>
<li>Project: Cross-platform card game</li>
</ul>
</div>
<div class="module-card-item"><span class="module-number-badge">Module 3</span>
<h3>Game mechanics en wiskunde</h3>
<div class="module-duration-info">6 weken · 15-18 uur per week</div>
<p class="module-description-text">Hier wordt het interessant. Je leert hoe casino mechanics echt werken: RNG systemen, probability, payout calculations, en balancing.</p>
<ul class="module-topics-list">
<li>Random number generation en fairness</li>
<li>Payout systemen en RTP berekeningen</li>
<li>Win frequency balancing</li>
<li>Bonus feature mathematics</li>
<li>Project: Volledig werkende roulette game</li>
</ul>
</div>
<div class="module-card-item"><span class="module-number-badge">Module 4</span>
<h3>Visual effects en animatie</h3>
<div class="module-duration-info">6 weken · 12-15 uur per week</div>
<p class="module-description-text">Games moeten niet alleen werken, ze moeten ook goed aanvoelen. Je leert particle systems, smooth animations, en satisfying feedback loops.</p>
<ul class="module-topics-list">
<li>Particle systems voor wins en effecten</li>
<li>Easing functions en timing</li>
<li>Audio integratie en sound design</li>
<li>Juice en game feel principles</li>
<li>Project: Geanimeerde slot game met effects</li>
</ul>
</div>
<div class="module-card-item"><span class="module-number-badge">Module 5</span>
<h3>Backend en multiplayer features</h3>
<div class="module-duration-info">7 weken · 15-18 uur per week</div>
<p class="module-description-text">Social games hebben een backend nodig. Je leert Node.js basics, real-time communicatie met WebSockets, en data persistence.</p>
<ul class="module-topics-list">
<li>Node.js en Express fundamentals</li>
<li>WebSocket communicatie</li>
<li>Database basics met MongoDB</li>
<li>Leaderboards en social features</li>
<li>Project: Multiplayer poker room</li>
</ul>
</div>
<div class="module-card-item"><span class="module-number-badge">Module 6</span>
<h3>Portfolio en productie</h3>
<div class="module-duration-info">7 weken · 18-20 uur per week</div>
<p class="module-description-text">In de laatste module bouw je een volledige game van A tot Z. Je kiest je eigen concept, maakt een production plan, en levert een gepolijst eindproduct.</p>
<ul class="module-topics-list">
<li>Game concept development</li>
<li>Production planning en scoping</li>
<li>Code review en optimization</li>
<li>Testing en debugging workflows</li>
<li>Project: Je eigen originele casino game</li>
</ul>
</div>
</div>
</div>
</section>
<section class="projecten-showcase-section">
<div class="projecten-content-wrapper">
<div class="projecten-intro-block">
<h2>Echte projecten, echte vaardigheden</h2>
<p class="projecten-lead-text">Elk project dat je maakt tijdens het programma gaat naar je portfolio. Dit zijn geen simpele oefeningen - het zijn volledige, speelbare games die je kunt demonstreren aan potentiële werkgevers. Hier zijn twee voorbeelden van wat studenten recent hebben gebouwd.</p>
</div>
<div class="project-examples-grid">
<div class="project-detail-card">
<h3>Fortune Spinner</h3>
<div class="project-tech-stack">Tech stack: JavaScript · Canvas API · Web Audio API · Local Storage</div>
<p class="project-description-full">Een klassieke slot machine met moderne twist. Studenten bouwen dit in module 4, nadat ze de fundamenten van animatie en effects hebben geleerd. De game heeft vijf reels, twintig paylines, en een bonus wheel feature die wordt getriggerd door scatter symbolen.</p>
<p class="project-description-full">Het interessante aan dit project is de wiskundige balancing. Je moet niet alleen de game laten draaien, maar ook zorgen dat de RTP tussen 94-96% blijft over duizenden spins. Dat vereist nauwkeurige berekeningen en veel testen.</p>
<div class="project-learning-outcomes">
<h4>Wat je hierbij leert:</h4>
<ul class="outcomes-list">
<li>Complexe animatie sequenties choreograferen</li>
<li>Symbol weighting en payout tabel configuratie</li>
<li>State machines voor bonus features</li>
<li>Performance optimization bij veel animaties</li>
</ul>
</div>
</div>
<div class="project-detail-card">
<h3>Texas Hold'em Room</h3>
<div class="project-tech-stack">Tech stack: Node.js · WebSockets · MongoDB · React voor UI</div>
<p class="project-description-full">Dit is het capstone project van module 5. Een volledig werkende multiplayer poker room waar vier spelers tegelijk kunnen spelen. De backend handelt game state, bet validation, en pot calculations. De frontend toont real-time updates voor alle spelers.</p>
<p class="project-description-full">De uitdaging hier zit hem in de synchronisatie. Elke actie moet naar alle clients worden gecommuniceerd zonder vertraging, en je moet edge cases afhandelen zoals disconnects mid-game. Het is technisch veeleisend, maar ook het meest bevredigende project om werkend te krijgen.</p>
<div class="project-learning-outcomes">
<h4>Wat je hierbij leert:</h4>
<ul class="outcomes-list">
<li>Real-time bidirectionele communicatie</li>
<li>Game state synchronisatie tussen clients</li>
<li>Turn-based game logic implementatie</li>
<li>Database design voor multiplayer data</li>
</ul>
</div>
</div>
</div>
<div class="visual-content-showcase"><img src="./assets/9876.jpg" alt="Student werkt aan game development project op laptop met code editor en game preview zichtbaar" width="1200" height="675" loading="lazy"></div>
</div>
</section>
<section class="docenten-team-section">
<div class="docenten-wrapper">
<div class="docenten-header-area">
<h2>Leer van mensen die het vak doen</h2>
<p class="docenten-subheading">Onze instructors zijn geen fulltime docenten. Ze zijn developers die momenteel in de gaming industrie werken en hun kennis delen. Je krijgt feedback van mensen die precies weten waar studios naar zoeken.</p>
</div>
<div class="docenten-profiles-layout">
<div class="docent-profile-card">
<div class="docent-image-container"><img src="./assets/4081.jpg" alt="Portret van Joris Vermeer, lead developer bij Ultimategameplay" width="400" height="280" loading="lazy"></div>
<div class="docent-info-content">
<h3>Joris Vermeer</h3>
<span class="docent-role-label">Lead Developer</span>
<p class="docent-bio-text">Joris werkt sinds 2018 aan social casino games en heeft aan meer dan twintig titels bijgedragen. Hij geeft de modules over game mechanics en mathematics. Verwacht veel diepgang over hoe RNG systemen echt in elkaar zitten.</p>
<div class="docent-specialties"><span class="specialty-tag">Game Mathematics</span> <span class="specialty-tag">RNG Systems</span> <span class="specialty-tag">JavaScript</span></div>
</div>
</div>
<div class="docent-profile-card">
<div class="docent-image-container"><img src="./assets/470382.jpg" alt="Portret van Saskia Brands, frontend specialist bij Ultimategameplay" width="400" height="280" loading="lazy"></div>
<div class="docent-info-content">
<h3>Saskia Brands</h3>
<span class="docent-role-label">Frontend Specialist</span>
<p class="docent-bio-text">Saskia is gespecialiseerd in mobile optimization en visual effects. Ze heeft gewerkt aan enkele van de meest populaire slot games op de Nederlandse markt. In haar modules leer je hoe je games smooth laat draaien op low-end devices.</p>
<div class="docent-specialties"><span class="specialty-tag">Mobile Development</span> <span class="specialty-tag">Animation</span> <span class="specialty-tag">Performance</span></div>
</div>
</div>
<div class="docent-profile-card">
<div class="docent-image-container"><img src="./assets/56194.jpg" alt="Portret van Lisa Dekkers, backend engineer bij Ultimategameplay" width="400" height="280" loading="lazy"></div>
<div class="docent-info-content">
<h3>Lisa Dekkers</h3>
<span class="docent-role-label">Backend Engineer</span>
<p class="docent-bio-text">Lisa bouwt de server-side infrastructuur voor multiplayer features. Haar achtergrond zit in fintech, wat perfect past bij casino games waar data integriteit cruciaal is. Ze geeft de modules over backend development en real-time systems.</p>
<div class="docent-specialties"><span class="specialty-tag">Node.js</span> <span class="specialty-tag">WebSockets</span> <span class="specialty-tag">Database Design</span></div>
</div>
</div>
</div>
</div>
</section>
<section class="praktische-informatie-section">
<div class="praktische-content-box">
<div class="praktische-header-zone">
<h2>Praktische details</h2>
</div>
<div class="info-columns-layout">
<div class="info-column-block">
<h3>Programma structuur</h3>
<ul class="info-details-list">
<li><span class="info-label-text">Duur:</span> <span class="info-value-text">32 weken (8 maanden)</span></li>
<li><span class="info-label-text">Tijdsinvestering:</span> <span class="info-value-text">12-20 uur per week</span></li>
<li><span class="info-label-text">Format:</span> <span class="info-value-text">Online met wekelijkse live sessies</span></li>
<li><span class="info-label-text">Cohort grootte:</span> <span class="info-value-text">Max 24 studenten</span></li>
<li><span class="info-label-text">Live sessies:</span> <span class="info-value-text">Dinsdag en donderdag 19:00-21:00</span></li>
</ul>
</div>
<div class="info-column-block">
<h3>Wat je nodig hebt</h3>
<ul class="info-details-list">
<li><span class="info-label-text">Voorkennis:</span> <span class="info-value-text">Geen programmeerervaring vereist</span></li>
<li><span class="info-label-text">Hardware:</span> <span class="info-value-text">Laptop of desktop (min 8GB RAM)</span></li>
<li><span class="info-label-text">Software:</span> <span class="info-value-text">Gratis ontwikkeltools (we helpen met setup)</span></li>
<li><span class="info-label-text">Internet:</span> <span class="info-value-text">Stabiele verbinding voor live sessies</span></li>
<li><span class="info-label-text">Leeftijd:</span> <span class="info-value-text">18+ (ivm casino gaming context)</span></li>
</ul>
</div>
</div>
<div class="aanmelden-cta-box">
<h3>Start in maart 2026</h3>
<p>Het volgende cohort begint op 9 maart 2026. Plaatsen zijn beperkt tot 24 studenten. Aanmelden kan tot 1 maart, maar we raden aan vroeg te registreren omdat plekken meestal snel vol zitten.</p>
<a href="./reach-us.php" class="cta-button-primary">Neem contact op voor meer informatie</a></div>
</div>
</section>
</main>
<footer role="contentinfo">
<div class="bv4_footerContent">
<div class="mn7-footer_upperZone">
<div class="qx9_container">
<div class="op3_footerGrid">
<div class="lk6-footerColumn">
<h3>Navigatie</h3>
<ul class="uv9_footerLinks">
<li><a href="./" class="jk2_footerLink">Startpagina</a></li>
<li><a href="./games.php" class="jk2_footerLink">Games</a></li>
<li><a href="./who-we-are.php" class="jk2_footerLink">Over Ons</a></li>
<li><a href="./education.php" class="jk2_footerLink">Lesprogramma</a></li>
</ul>
</div>
<div class="lk6-footerColumn">
<h3>Juridisch</h3>
<ul class="uv9_footerLinks">
<li><a href="./cookie-settings.php" class="jk2_footerLink">Cookiebeleid</a></li>
<li><a href="./site-terms.php" class="jk2_footerLink">Gebruiksvoorwaarden</a></li>
<li><a href="./legal-statement.php" class="jk2_footerLink">Disclaimer</a></li>
<li><a href="./privacy.php" class="jk2_footerLink">Privacybeleid</a></li>
<li><a href="./copyright-notice.php" class="jk2_footerLink">DMCA</a></li>
</ul>
</div>
<div class="lk6-footerColumn">
<h3>Contact</h3>
<ul class="uv9_footerLinks">
<li><a href="./reach-us.php" class="jk2_footerLink">Neem Contact Op</a></li>
<li><a href="./help.php" class="jk2_footerLink">Support</a></li>
</ul>
</div>
</div>
</div>
</div>
<div class="gh8_footerLowerZone">
<div class="qx9_container">
<div class="ty5-footerBottom_grid">
<div class="pw7_ageRestriction">18+ Educatieve Inhoud</div>
<div class="qz3_educationalDisclaimer"><strong>Belangrijke Educatieve Mededeling:</strong> Dit is een opleidingsplatform voor sociale casino game-ontwikkeling. Games die via onze trainingen worden gemaakt dienen uitsluitend voor entertainment-doeleinden, niet voor echt geldgokken. Er kunnen geen echte geldprijzen of beloningen worden gewonnen met games ontwikkeld via onze educatieve content. Deze website is puur bedoeld voor entertainment, zonder gebruik van echt geld zoals contante prijzen, gratis spins, cryptocurrency, sweep coins of inzetten.</div>
<div class="sd1_copyrightText">© 2025 Ultimategameplay. Alle rechten voorbehouden.</div>
</div>
</div>
</div>
</div>
</footer>
<div class="xm6_ageVerifyOverlay" id="ageVerifyOverlay">
<div class="bn4_ageVerifyModal">
<div class="cv8_modalIcon"></div>
<h2 class="lp2_modalTitle">Leeftijdsverificatie Vereist</h2>
<p class="mw5_modalText">Dit educatief platform voor sociale casino game-ontwikkeling is uitsluitend toegankelijk voor personen van 18 jaar of ouder. Wij bieden professionele training in verantwoorde game-ontwikkeling voor entertainment-doeleinden.</p>
<div class="kr9_buttonGroup"><button class="tf1_verifyBtn accept" id="confirmAgeBtn">Ik ben 18+</button> <button class="tf1_verifyBtn deny" id="denyAgeBtn">Nog geen 18</button></div>
<div class="hn6_denialMessage" id="denialMessage">Bedankt voor je eerlijkheid. Deze educatieve content is uitsluitend bestemd voor volwassenen van 18 jaar en ouder. Kom gerust terug wanneer je de vereiste leeftijd hebt bereikt om je te verdiepen in professionele game-ontwikkeling.</div>
</div>
</div>
<div class="yu7_cookieConsent" id="cookieConsent" style="display: none;">
<h3 class="wq4_cookieTitle">Cookie-voorkeuren</h3>
<p class="vn3_cookieText">Onze website maakt gebruik van cookies om de gebruikerservaring te verbeteren en educatieve content optimaal te presenteren. Je kunt je voorkeuren hieronder aanpassen.</p>
<div class="az2_cookieButtons"><button class="rx5_cookieBtn accept-all" id="acceptAllCookies">Alles Accepteren</button> <button class="rx5_cookieBtn reject-all" id="rejectAllCookies">Alles Weigeren</button></div>
</div>
<script>
(function() {
const ageOverlay = document.getElementById('ageVerifyOverlay');
const confirmBtn = document.getElementById('confirmAgeBtn');
const denyBtn = document.getElementById('denyAgeBtn');
const denialMsg = document.getElementById('denialMessage');
const cookieConsent = document.getElementById('cookieConsent');
const acceptAllBtn = document.getElementById('acceptAllCookies');
const rejectAllBtn = document.getElementById('rejectAllCookies');
const storageKey = 'ageVerified_wriltek_' + Date.now();
function checkAgeVerification() {
const verified = localStorage.getItem(storageKey);
if (verified === 'true') {
ageOverlay.style.display = 'none';
showCookieConsent();
}
}
function showCookieConsent() {
const cookieChoice = localStorage.getItem('cookieConsent_wriltek');
if (!cookieChoice) {
cookieConsent.style.display = 'block';
}
}
confirmBtn.addEventListener('click', function() {
try {
localStorage.setItem(storageKey, 'true');
ageOverlay.style.display = 'none';
showCookieConsent();
} catch (e) {
console.error('Storage error:', e);
}
});
denyBtn.addEventListener('click', function() {
denialMsg.style.display = 'block';
});
acceptAllBtn.addEventListener('click', function() {
try {
localStorage.setItem('cookieConsent_wriltek', 'granted');
cookieConsent.style.display = 'none';
} catch (e) {
console.error('Storage error:', e);
}
});
rejectAllBtn.addEventListener('click', function() {
try {
localStorage.setItem('cookieConsent_wriltek', 'denied');
cookieConsent.style.display = 'none';
} catch (e) {
console.error('Storage error:', e);
}
});
checkAgeVerification();
})();
</script>
</body>
</html>